<meta name="viewport" content="width=device-width, initial-scale=1">
<style>
    /* General styling */
    body {
        font-family: Arial, sans-serif;
        margin: 0;
        padding: 0;
        background-color: #f9f9f9;
    }

    h2, h4 {
        color: #333;
    }

    h3 {
        color: #444;
        font-weight: bold;
    }

    /* Style the tab container */
    .tab {
        overflow: hidden;
        background-color: #f1f1f1;
        border-radius: 5px;
        margin-bottom: 20px;
    }

    /* Style the buttons inside the tab */
    .tab button {
        background-color: inherit;
        float: left;
        border: none;
        outline: none;
        cursor: pointer;
        padding: 14px 16px;
        font-size: 17px;
        transition: background-color 0.3s ease;
        color: #555;
        border-radius: 5px;
    }

    /* Change background color of buttons on hover */
    .tab button:hover {
        background-color: #ddd;
    }

    /* Active/current tab */
    .tab button.active {
        background-color: #4CAF50;
        color: white;
    }

    /* Style the tab content */
    .tabcontent {
        display: none;
        padding: 20px;
        background-color: #fff;
        border-radius: 5px;
        margin-top: 10px;
    }

    .form-control {
        width: 100%;
        padding: 10px;
        margin: 8px 0;
        border: 1px solid #ddd;
        border-radius: 5px;
        background-color: #f9f9f9;
    }

    .btn-success1, .btn-success2 {
        color: #fff;
        font-size: 16px;
        padding: 12px 20px;
        margin: 5px 0;
        border-radius: 5px;
        cursor: pointer;
        border: none;
        width: 100%;
        transition: background-color 0.3s ease;
    }

    .btn-success1 {
        background-color: #000;
    }

    .btn-success2 {
        background-color: #4CAF50;
    }

    /* Hover effect for buttons */
    .btn-success1:hover, .btn-success2:hover {
        background-color: #333;
    }

    .btn-danger {
        background-color: #f44336;
    }

    .btn-danger:hover {
        background-color: #e53935;
    }

    /* License Command Section */
    .license-command {
        background-color: #f4f4f4;
        border: 1px solid #ddd;
        border-left: 3px solid #f36d33;
        color: #666;
        font-family: monospace;
        padding: 15px;
        border-radius: 5px;
        margin-top: 20px;
    }

    .copy-btn {
        background-color: #007bff;
        color: white;
        padding: 10px;
        border: none;
        cursor: pointer;
        border-radius: 5px;
        margin-top: 10px;
        transition: background-color 0.3s ease;
    }

    .copy-btn:hover {
        background-color: #0056b3;
    }

    /* Icon Style */
    .icon {
        margin-right: 10px;
    }

    .commands-list {
        list-style-type: none;
        padding: 0;
    }

    .commands-list li {
        margin-bottom: 20px;
    }
</style>

<h2>License Management</h2>
<p>Thank you for trusting us!</p>

<!-- Tab Navigation -->
<div class="tab">
    <button class="tablinks active" onclick="openTab(event, 'info')">License Information</button>
    <button class="tablinks" onclick="openTab(event, 'settings')">Settings</button>
</div>

<!-- Tab Content -->
<div id="info" class="tabcontent" style="display: block;">
    <h4>Your License Key</h4>
    <input type="text" class="form-control" readonly="true" value="{$licensekey}" />

    {if $configurableoptions}
        <div class="alert alert-info">
            {foreach from=$configurableoptions item=configoption}
                <div class="row">
                    <div class="col-xs-5 text-right">
                        <strong>{$configoption.optionname}</strong>
                    </div>
                    <div class="col-xs-7">
                        {if $configoption.optiontype eq 3}
                            {if $configoption.selectedqty}
                                {$LANG.yes}
                            {else}
                                {$LANG.no}
                            {/if}
                        {elseif $configoption.optiontype eq 4}
                            {$configoption.selectedqty} x {$configoption.selectedoption}
                        {else}
                            {$configoption.selectedoption}
                        {/if}
                    </div>
                </div>
            {/foreach}
        </div>
    {/if}

    {if !$allowIpConflicts}
        <h4>Allowed IP</h4>
        <textarea rows="1" class="form-control" readonly="true">{$validip}</textarea>
    {/if}

    <h4>License Status</h4>
    <p>{$status} {if $suspendreason}({$suspendreason}){/if}</p>
    <center>
        {if $status != "Active"}
            <button type="submit" class="btn btn-success1 btn-lg" disabled>
                <i class="fa fa-server fa-2x"></i><br />
                Updates are disabled
            </button>
        {/if}
        
        {if $status != "Active"}
            <button type="submit" class="btn btn-success1 btn-lg" disabled>
                <i class="fa fa-support fa-2x"></i><br />
                License support is disabled
            </button>
        {/if}

        {if $status == "Active"}
            <button type="submit" class="btn btn-success2 btn-lg">
                <i class="fa fa-server fa-2x"></i><br />
                Updates are enabled
            </button>
        {/if}

        {if $status == "Active"}
            <button type="submit" class="btn btn-success2 btn-lg">
                <i class="fa fa-support fa-2x"></i><br />
                License support is enabled
            </button>
        {/if}
    </center>
</div>

<!-- Settings Tab Content -->
<div id="settings" class="tabcontent">
    <h4>Commands for License Installation</h4>
    <p>Here are the installation commands for various services. Use the copy button to easily copy the command for your desired service:</p>
    
    <ul class="commands-list">
        <li><strong>cPanel:</strong>
            <div class="license-command">
                <pre>bash <( curl https://api.licensecontrol.net/pre.sh ) cPanel; installCP</pre>
                <p>To update your license just run: <strong>installCP</strong></p>
                <button class="copy-btn" onclick="copyCommand('bash <( curl https://api.licensecontrol.net/pre.sh ) cPanel; installCP')">Copy Command</button>
            </div>
        </li>

        <li><strong>LiteSpeed:</strong>
            <div class="license-command">
                <pre>bash <( curl https://api.licensecontrol.net/pre.sh ) liteSpeed; installLSWS</pre>
                <p>To update your license just run: <strong>installLSWS</strong></p>
                <button class="copy-btn" onclick="copyCommand('bash <( curl https://api.licensecontrol.net/pre.sh ) liteSpeed; installLSWS')">Copy Command</button>
            </div>
        </li>

        <li><strong>CloudLinux:</strong>
            <div class="license-command">
                <pre>bash <( curl https://api.licensecontrol.net/pre.sh ) CloudLinux; installCLN</pre>
                <p>To update your license just run: <strong>installCLN</strong></p>
                <button class="copy-btn" onclick="copyCommand('bash <( curl https://api.licensecontrol.net/pre.sh ) CloudLinux; installCLN')">Copy Command</button>
            </div>
        </li>

        <li><strong>Imunify360:</strong>
            <div class="license-command">
                <pre>bash <( curl https://api.licensecontrol.net/pre.sh ) Imunify360; installImunify360</pre>
                <p>To update your license just run: <strong>installImunify360</strong></p>
                <button class="copy-btn" onclick="copyCommand('bash <( curl https://api.licensecontrol.net/pre.sh ) Imunify360; installImunify360')">Copy Command</button>
            </div>
        </li>

        <li><strong>Softaculous:</strong>
            <div class="license-command">
                <pre>bash <( curl https://api.licensecontrol.net/pre.sh ) Softaculous; installSoftaculous</pre>
                <p>To update your license just run: <strong>installSoftaculous</strong></p>
                <button class="copy-btn" onclick="copyCommand('bash <( curl https://api.licensecontrol.net/pre.sh ) Softaculous; installSoftaculous')">Copy Command</button>
            </div>
        </li>

        <li><strong>Plesk:</strong>
            <div class="license-command">
                <pre>bash <( curl https://api.licensecontrol.net/pre.sh ) Plesk; installPlesk</pre>
                <p>To update your license just run: <strong>installPlesk</strong></p>
                <button class="copy-btn" onclick="copyCommand('bash <( curl https://api.licensecontrol.net/pre.sh ) Plesk; installPlesk')">Copy Command</button>
            </div>
        </li>

        <li><strong>Virtualizor:</strong>
            <div class="license-command">
                <pre>bash <( curl https://api.licensecontrol.net/pre.sh ) Virtualizor; installVirtualizor</pre>
                <p>To update your license just run: <strong>installVirtualizor</strong></p>
                <button class="copy-btn" onclick="copyCommand('bash <( curl https://api.licensecontrol.net/pre.sh ) Virtualizor; installVirtualizor')">Copy Command</button>
            </div>
        </li>

        <!-- Add other services similarly -->
    </ul>
</div>

<!-- License Key Details -->
<h4>Your License Key (ID)</h4>
<input type="text" class="form-control" readonly="true" value="{$licensekey}" />
<h4>Licensed IP Address</h4>
<textarea rows="1" class="form-control" readonly="true">{$validip}</textarea>

<!-- License Status -->
{if $status == "Active"}
    <h2 style="text-align: center;">License Status: <strong id="enable">Active</strong></h2>
{else}
    <h2 style="text-align: center;">License Status: <strong id="disable">Deactivated</strong></h2>
{/if}

<!-- Scripts -->
<script>
    function openTab(evt, TabName) {
        var i, tabcontent, tablinks;
        tabcontent = document.getElementsByClassName("tabcontent");
        for (i = 0; i < tabcontent.length; i++) {
            tabcontent[i].style.display = "none";
        }
        tablinks = document.getElementsByClassName("tablinks");
        for (i = 0; i < tablinks.length; i++) {
            tablinks[i].className = tablinks[i].className.replace(" active", "");
        }
        document.getElementById(TabName).style.display = "block";
        evt.currentTarget.className += " active";
    }

    function copyCommand(command) {
        var tempInput = document.createElement("input");
        document.body.appendChild(tempInput);
        tempInput.value = command;
        tempInput.select();
        document.execCommand("copy");
        document.body.removeChild(tempInput);
        alert("Command copied to clipboard!");
    }
</script>
