<?php
namespace lc;


class Plugin_Logic {


  function __construct() {
    // add_action('template_redirect', array($this, 'vpn_check')); 
    add_action('woocommerce_before_checkout_process', array($this, 'custom_pre_order_action'));
    add_action('woocommerce_new_order', array($this, 'capture_ip_address'));
  }


  // Run Time Works below

  function custom_pre_order_action() {

    $this->vpn_check();

    // Example: Check if the customer's IP address is within a restricted range
    // Example usage with the configured time period
    $time_period = get_option('order_time_period', 0); // Get the configured time period (in seconds)
    $max_order_count = get_option('max_orders_within_period', 1); // Get the maximum order count from the configuration
    $isIPrestriction = get_option('enable_ip_restriction', false); // Get the configured enable/disable IP
    $isPhoneRestriction = get_option('enable_phone_restriction', false); // Get the configured enable/disable IP
    $ip_address = $_SERVER['REMOTE_ADDR'];

    // Mobile Number restricted
    $isPhoneRestrictionCount = $this->phone_number_is_restricted($_POST['billing_phone'], $time_period, $max_order_count); // Check phone number restriction

    if ($isPhoneRestriction && $isPhoneRestrictionCount) {
      wc_add_notice('Your IP address or phone number is restricted for placing orders within the configured time period.', 'error');
      return;
    }

    if ($isIPrestriction &&  $this->ip_address_is_restricted($ip_address, $time_period, $max_order_count)) {
      // IP address is restricted
      wc_add_notice('Your IP address is restricted for placing orders within the configured time period.', 'error');
      return;
    }

  }

  function phone_number_is_restricted($phone_number, $time_period, $max_order_count) {
    global $wpdb;

    // Calculate the date and time from the current moment minus the provided time period (in seconds)
    $max_order_age_seconds = $time_period * 24 * 3600;
    $max_order_age_start_date = date('Y-m-d H:i:s', strtotime("-$max_order_age_seconds seconds"));

    // Query to count orders with the same phone number and within the time period
    $args = array(
        'limit'        => -1, // Get all orders
        'type'         => 'shop_order', // Order post type
        'return'       => 'ids', // Return only order IDs
        'date_created' => '>=' . strtotime($max_order_age_start_date), // Filter by creation date
        'billing_phone' => $phone_number, // Filter by billing phone number
    );
    
    // Get orders
    $order_ids = wc_get_orders($args);
    
    // Count the number of orders
    $order_count = count($order_ids);
    
    // If there are orders with the phone number within the time period, return true (restricted)
    if ($order_count >= $max_order_count && $max_order_count != 0) {
      return true;
    }

    // If no orders with the phone number within the time period, return false (not restricted)
    return false;
  }


  function ip_address_is_restricted($ip_address, $time_period, $max_order_count) {
    global $wpdb;

    // Calculate the date and time from the current moment minus the provided time period (in seconds)
    $max_order_age_seconds = $time_period * 24 * 3600;
    $max_order_age_start_date = date('Y-m-d H:i:s', strtotime("-$max_order_age_seconds seconds"));

    // Query the WooCommerce orders table to check for orders with the given IP within the time period
    $args = array(
        'limit'        => -1, // Get all orders
        'type'         => 'shop_order', // Order post type
        'return'       => 'ids', // Return only order IDs
        'date_created' => '>=' . strtotime($max_order_age_start_date), // Filter by creation date
        'customer_ip_address' => $ip_address, // Filter by customer IP address
    );
    
    // Get orders
    $order_ids = wc_get_orders($args);
    
    // Count the number of orders
    $order_count = count($order_ids);

    // If there are orders with the IP address within the time period, return true (restricted)
    if ($order_count >= $max_order_count) {
      return true;
    }

    // If no orders with the IP address within the time period, return false (not restricted)
    return false;
  }


  function capture_ip_address($order_id) {
    $order = wc_get_order($order_id);
    $customer_ip = $_SERVER['REMOTE_ADDR'];

    // Update the 'ip_address' column in the 'wp_woocommerce_order_stats' table with the customer's IP address
    global $wpdb;
    $wpdb->update($wpdb->prefix . 'wc_orders', array('ip_address' => $customer_ip), array('id' => $order_id));
  }


  /* Belows All function for VPN Logics */

  // Function to check if IP address exists in the custom database table
  function ip_blocker_ip_exists($ip) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'ip_details';
    $result = $wpdb->get_row(
      $wpdb->prepare("SELECT vpn_detected, proxy_detected FROM $table_name WHERE ip_address = %s", $ip)
    );
    return $result;
  }


  // Function to insert IP details into the custom database table
  function ip_blocker_insert_ip_details($ip_details) {
    global $wpdb;
    $table_name = $wpdb->prefix . 'ip_details';
    $wpdb->insert(
        $table_name,
        array(
            'ip_address' => $ip_details['ip'],
            'country' => 'N/A',
            'region' => 'N/A',
            'city' => 'N/A',
            'isp' => 'N/A',
            'vpn_detected' => $ip_details['proxy'] ? 1 : 0,
            'proxy_detected' => 0,
            'tor_detected' => 0,
            'relay_detected' => 0,
        )
    );

    return;
    
    // Reload the current page
    // $current_url = home_url(add_query_arg(array(), $wp->request));
    // wp_redirect($current_url);
    // exit;
  }

  // Function to retrieve IP details using VPNAPI.io
  function ip_blocker_get_ip_details($ip) {
    $vpn_api_key = get_option('vpn_api', ''); 
    $url = 'https://api.isproxyip.com/v1/check.php?format=json&key=' . urlencode($vpn_api_key) . '&ip=' . $ip;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    if(curl_errno($ch)){
        echo 'Curl error: ' . curl_error($ch);
        exit;
    }
    curl_close($ch);

    $data = json_decode($response, true);

    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    if ($http_code !== 200) {
      if (isset($data['message'])) {
        wc_add_notice('VPN/Poxy Error: ' . $data['message'], 'error');
        return;
      }else {
        wc_add_notice('Error: Unknown error occurred about VPN/Poxy API', 'error');
        return;
      }
    }
    return $data;
  }

  function vpn_check() {
    // Checking first about vpn restriction
    $isVPNenable = get_option('enable_vpn_restriction', 0);
    if ($isVPNenable) {
      $user_ip = $_SERVER['REMOTE_ADDR'];
      // Check if IP address exists in the custom database table
      $ip_details = $this->ip_blocker_ip_exists($user_ip);
      if (!$ip_details) {
        // If IP address doesn't exist in the table, fetch data from VPNAPI.io API
        $ip_details = $this->ip_blocker_get_ip_details($user_ip);

        if($ip_details['status'] != 'success'){
          wc_add_notice('VPN/Proxy error: ' . $ip_details['message'], 'error');
          return;
        }
        
        // Insert IP details into the custom database table
        $this->ip_blocker_insert_ip_details($ip_details);
        $ip_details = $this->ip_blocker_ip_exists($user_ip);
      }
      // Check if VPN or proxy detected
      if ($ip_details->vpn_detected == 1 || $ip_details->proxy_detected == 1) {
        // Block access for VPN or proxy users
        wc_add_notice('Access denied. Please disable your VPN or proxy to place the order. <br> Copyright © LC Plugin', 'error');
        return;
      }
    }
    return;
  }


}
