<?php
/**
 * @wordpress-plugin
 * Plugin Name:       LC Plugin
 * Plugin URI:        https://dash.licensecontrol.net/index.php/store/wordpress-theme-plugin-lc/lc-plugin-protect-your-fake-order
 * Description:      LC PLUGIN 100% Fake Order Solution For WooCommerce By Mobile Number, IP Address & VPN/Proxy Block etc.
 * Version:           2.0.1
 * Author:            LC DEV Team
 * Author URI:        https://licensecontrol.net
 * License URI:       https://dash.licensecontrol.net/index.php/store/wordpress-theme-plugin-lc/lc-plugin-protect-your-fake-order
 * * Text Domain:       lc_plugin
 * Domain Path:       languages
 */

/*
* Copyright 2023-2024     LC (https://github.com/licensecontrol)
*/

if( !defined( 'ABSPATH' ) ) die();
require( __DIR__ . '/vendor/autoload.php' );
require( __DIR__ . '/app/Settings_Page.php' );
require( __DIR__ . '/app/Plugin_Logic.php' );


class lc_Order_Restriction_Plugin  {

  public $status;
 
  function __construct() {

    // Validate license
    $license_check = new \WordPress_ToolKit\Licensing\WHMCS_License( __DIR__ . '/plugin.json', array( 'plugin' => array( 'path' => __DIR__ ) ) );

    $result = $license_check->validate( $this->get_plugin_option( $license_check->get_config( 'prefix' ) . '_license_key', $license_check->get_config( 'prefix' ) . '_options' ), get_option( $license_check->get_config( 'prefix' ) . '_local_key' ) );
    if( isset( $result['remotecheck'] ) ) update_option( $license_check->get_config( 'prefix' ) . '_local_key', isset( $result['localkey'] ) ? $result['localkey'] : '' );

    // Load settings page
    $this->status =  $result['status'];
    new \lc\Settings_Page( $license_check->get_config(), $this->status );

    // Display license notice, if invalid
    if ($result['status'] != 'Active') {
      if (is_admin()) {
        $this->show_admin_notice($result['status']);
      }
      return;
    }
  
    // When license activated then
    new \lc\Plugin_Logic();

  }

  private function get_plugin_option( $key, $group, $cache = true ) {
    $options = get_option( $group );
    return isset( $options[ $key ] ) ? $options[ $key ] : null;
  }

  // Display admin notice on license check failure
  private function show_admin_notice($status) {
    $class = 'notice notice-error';
    $message = sprintf(__('lc Plugin: Invalid license. Response: %s', 'lc_plugin'), $status);

    add_action('admin_notices', function () use ($class, $message) {
      printf('<div class="%1$s"><p>%2$s</p></div>', esc_attr($class), esc_html($message));
    });
  }

}


// Function to create custom database table
function ip_blocker_create_table() {
  global $wpdb;

  $table_name = $wpdb->prefix . 'ip_details';

  $charset_collate = $wpdb->get_charset_collate();

  $sql = "CREATE TABLE IF NOT EXISTS $table_name (
      id mediumint(9) NOT NULL AUTO_INCREMENT,
      ip_address varchar(100) NOT NULL,
      country varchar(100),
      region varchar(100),
      city varchar(100),
      isp varchar(100),
      vpn_detected tinyint(1),
      proxy_detected tinyint(1),
      tor_detected tinyint(1),
      relay_detected tinyint(1),
      PRIMARY KEY  (id)
  ) $charset_collate;";

  require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
  dbDelta($sql);
}

// Create custom database table on plugin activation
register_activation_hook(__FILE__, 'ip_blocker_create_table');

new lc_Order_Restriction_Plugin();